
capture program drop householdSize
program define householdSize

version 13.1
*! version 1.0 January 22, 2016

display ""
display "Start of the program to create HOUSEHOLD SIZE"
which householdSize
display ""

display "	Part 1: Checking that all the files used are available."
capture use METADATA.dta
	if _rc!=0{
	display "	File METADATA.DTA not found."
	display "	The program HOUSEHOLD SIZE was stopped."
	qui exit"
	}
capture use INDIV_CONTEXT.dta
	if _rc!=0{
	display "	File INDIV_CONTEXT.dta not found."
	display "	The program HOUSEHOLD SIZE was stopped."
	qui exit"
	}
capture use CONTEXT.dta
	if _rc!=0{
	display "	File CONTEXT.dta not found."
	display "	The program HOUSEHOLD SIZE was stopped."
	qui exit"
	}
capture use CONTEXT_EXT.dta
	if _rc!=0{
	display "	File CONTEXT_EXT.dta not found. Run the program IDSextended to create it."
	display "	The program HOUSEHOLD SIZE was stopped."
	qui exit"
	}

display "	Part 2: Selecting household information from the INDIV_CONTEXT table"
qui{ 
use CONTEXT.dta, clear
keep if Type=="Level" | Type=="LEVEL-NAME"
keep if Value=="Household"
keep Id_C
merge 1:m Id_C using INDIV_CONTEXT.dta
keep if _merge==3
drop _merge
}

display "	Part 3: Creating variable household size"
qui{

foreach datevar of varlist Start_day Start_month Start_year End_day End_month End_year{
destring `datevar', replace
}

gen Start_date=mdy( Start_month, Start_day, Start_year)
gen End_date=mdy( End_month, End_day, End_year)
format Start_date End_date %td

foreach datevar of varlist Start_day Start_month Start_year End_day End_month End_year{
drop `datevar'
}

tempfile ic
save `ic'

collapse (count) change = Id_I,by (Id_C Start_date Id_D)
rename Start_date Date

tempfile HHsize_change
save `HHsize_change'

use `ic',clear
collapse (count) temp = Id_I,by (Id_C End_date Id_D)
gen change = temp*-1
drop temp
rename End_date Date

append using `HHsize_change'

order Id_C Date change

collapse (sum) totchange = change,by(Id_C Date Id_D)
drop if totchange==0 

sort Id_C Date

bysort Id_C (Date): gen householdSize = totchange if _n==1
by Id_C: replace householdSize = householdSize[_n-1] + totchange if householdSize==.
drop totchange

gen Day = day(Date)
gen Month = month(Date)
gen Year = year(Date)
drop Date

rename householdSize Value
gen Type = "Household_size"
gen Source = "householdSize_program_v1"
tostring Value,replace

gen Date_type = "Declared"

tempfile householdSize
save `householdSize'
}

display "	Part 4: Appending household size to CONTEXT_EXT.dta"

qui {
use CONTEXT_EXT.dta, clear
append using `householdSize'
save CONTEXT_EXT.dta,replace
}

display "	Part 5: Appending the Type Household_size to METADATA.dta"


qui{
use METADATA.dta, clear
set obs `=_N+1'
replace Type="Household_size" if Type==""
replace Value = "Definition" if Type=="Household_size"
replace Extract= "householdSize_program_v1" if Type=="Household_size"
replace Type_T = "CONTEXT_EXT" if Type=="Household_size"
replace Id_D = Id_D[_n-1] if Type=="Household_size"
save METADATA.dta,replace
}
	



display ""
display "End of the program to create HOUSEHOLD SIZE"
end
